#ifndef DOM_BINDINGNAMES_H_
#define DOM_BINDINGNAMES_H_

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioData = 335,
  AudioDecoder = 345,
  AudioDestinationNode = 358,
  AudioEncoder = 379,
  AudioListener = 392,
  AudioNode = 406,
  AudioParam = 416,
  AudioParamMap = 427,
  AudioProcessingEvent = 441,
  AudioScheduledSourceNode = 462,
  AudioTrack = 487,
  AudioTrackList = 498,
  AudioWorklet = 513,
  AudioWorkletGlobalScope = 526,
  AudioWorkletNode = 550,
  AudioWorkletProcessor = 567,
  AuthenticatorAssertionResponse = 589,
  AuthenticatorAttestationResponse = 620,
  AuthenticatorResponse = 653,
  BarProp = 675,
  BaseAudioContext = 683,
  BatteryManager = 700,
  BeforeUnloadEvent = 715,
  BiquadFilterNode = 733,
  Blob = 750,
  BlobEvent = 755,
  BroadcastChannel = 765,
  BrowsingContext = 782,
  BrowsingContextGroup = 798,
  ByteLengthQueuingStrategy = 819,
  CDATASection = 845,
  CSPViolationReportBody = 858,
  CSS = 881,
  CSS2Properties = 885,
  CSSAnimation = 900,
  CSSConditionRule = 913,
  CSSContainerRule = 930,
  CSSCounterStyleRule = 947,
  CSSCustomPropertyRegisteredEvent = 967,
  CSSFontFaceRule = 1000,
  CSSFontFeatureValuesRule = 1016,
  CSSFontPaletteValuesRule = 1041,
  CSSGroupingRule = 1066,
  CSSImportRule = 1082,
  CSSKeyframeRule = 1096,
  CSSKeyframesRule = 1112,
  CSSLayerBlockRule = 1129,
  CSSLayerStatementRule = 1147,
  CSSMarginRule = 1169,
  CSSMediaRule = 1183,
  CSSMozDocumentRule = 1196,
  CSSNamespaceRule = 1215,
  CSSNestedDeclarations = 1232,
  CSSPageDescriptors = 1254,
  CSSPageRule = 1273,
  CSSPositionTryDescriptors = 1285,
  CSSPositionTryRule = 1311,
  CSSPropertyRule = 1330,
  CSSPseudoElement = 1346,
  CSSRule = 1363,
  CSSRuleList = 1371,
  CSSScopeRule = 1383,
  CSSStartingStyleRule = 1396,
  CSSStyleDeclaration = 1417,
  CSSStyleRule = 1437,
  CSSStyleSheet = 1450,
  CSSSupportsRule = 1464,
  CSSTransition = 1480,
  Cache = 1494,
  CacheStorage = 1500,
  CallbackDebuggerNotification = 1513,
  CanonicalBrowsingContext = 1542,
  CanvasCaptureMediaStream = 1567,
  CanvasGradient = 1592,
  CanvasPattern = 1607,
  CanvasRenderingContext2D = 1621,
  CaretPosition = 1646,
  CaretStateChangedEvent = 1660,
  ChannelMergerNode = 1683,
  ChannelSplitterNode = 1701,
  ChannelWrapper = 1721,
  CharacterData = 1736,
  CheckerboardReportService = 1750,
  ChildProcessMessageManager = 1776,
  ChildSHistory = 1803,
  ChromeMessageBroadcaster = 1817,
  ChromeMessageSender = 1842,
  ChromeNodeList = 1862,
  ChromeUtils = 1877,
  ChromeWorker = 1889,
  Client = 1902,
  Clients = 1909,
  Clipboard = 1917,
  ClipboardEvent = 1927,
  ClipboardItem = 1942,
  ClonedErrorHolder = 1956,
  CloseEvent = 1974,
  CloseWatcher = 1985,
  CommandEvent = 1998,
  Comment = 2011,
  CompositionEvent = 2019,
  CompressionStream = 2036,
  ConsoleInstance = 2054,
  ConstantSourceNode = 2070,
  ContentFrameMessageManager = 2089,
  ContentProcessMessageManager = 2116,
  ContentVisibilityAutoStateChangeEvent = 2145,
  ConvolverNode = 2183,
  CookieChangeEvent = 2197,
  CookieStore = 2215,
  CookieStoreManager = 2227,
  CountQueuingStrategy = 2246,
  CreateOfferRequest = 2267,
  Credential = 2286,
  CredentialsContainer = 2297,
  Crypto = 2318,
  CryptoKey = 2325,
  CustomElementRegistry = 2335,
  CustomEvent = 2357,
  CustomStateSet = 2369,
  DOMException = 2384,
  DOMImplementation = 2397,
  DOMLocalization = 2415,
  DOMMatrix = 2431,
  DOMMatrixReadOnly = 2441,
  DOMParser = 2459,
  DOMPoint = 2469,
  DOMPointReadOnly = 2478,
  DOMQuad = 2495,
  DOMRect = 2503,
  DOMRectList = 2511,
  DOMRectReadOnly = 2523,
  DOMStringList = 2539,
  DOMStringMap = 2553,
  DOMTokenList = 2566,
  DataTransfer = 2579,
  DataTransferItem = 2592,
  DataTransferItemList = 2609,
  DebuggerNotification = 2630,
  DebuggerNotificationObserver = 2651,
  DecompressionStream = 2680,
  DedicatedWorkerGlobalScope = 2700,
  DelayNode = 2727,
  DeprecationReportBody = 2737,
  DeviceAcceleration = 2759,
  DeviceLightEvent = 2778,
  DeviceMotionEvent = 2795,
  DeviceOrientationEvent = 2813,
  DeviceRotationRate = 2836,
  Directory = 2855,
  Document = 2865,
  DocumentFragment = 2874,
  DocumentL10n = 2891,
  DocumentTimeline = 2904,
  DocumentType = 2921,
  DominatorTree = 2934,
  DragEvent = 2948,
  DynamicsCompressorNode = 2958,
  EXT_blend_minmax = 2981,
  EXT_color_buffer_float = 2998,
  EXT_color_buffer_half_float = 3021,
  EXT_depth_clamp = 3049,
  EXT_disjoint_timer_query = 3065,
  EXT_float_blend = 3090,
  EXT_frag_depth = 3106,
  EXT_sRGB = 3121,
  EXT_shader_texture_lod = 3130,
  EXT_texture_compression_bptc = 3153,
  EXT_texture_compression_rgtc = 3182,
  EXT_texture_filter_anisotropic = 3211,
  EXT_texture_norm16 = 3242,
  Element = 3261,
  ElementInternals = 3269,
  EncodedAudioChunk = 3286,
  EncodedVideoChunk = 3304,
  ErrorEvent = 3322,
  Event = 3333,
  EventCallbackDebuggerNotification = 3339,
  EventCounts = 3373,
  EventSource = 3385,
  EventTarget = 3397,
  Exception = 3409,
  ExtendableCookieChangeEvent = 3419,
  ExtendableEvent = 3447,
  ExtendableMessageEvent = 3463,
  ExtensionAlarms = 3486,
  ExtensionBrowser = 3502,
  ExtensionBrowserSettings = 3519,
  ExtensionBrowserSettingsColorManagement = 3544,
  ExtensionDns = 3584,
  ExtensionEventManager = 3597,
  ExtensionMockAPI = 3619,
  ExtensionPort = 3636,
  ExtensionProxy = 3650,
  ExtensionRuntime = 3665,
  ExtensionScripting = 3682,
  ExtensionSetting = 3701,
  ExtensionTest = 3718,
  External = 3732,
  FeaturePolicy = 3741,
  FeaturePolicyViolationReportBody = 3755,
  FetchEvent = 3788,
  FetchObserver = 3799,
  File = 3813,
  FileList = 3818,
  FileReader = 3827,
  FileReaderSync = 3838,
  FileSystem = 3853,
  FileSystemDirectoryEntry = 3864,
  FileSystemDirectoryHandle = 3889,
  FileSystemDirectoryHandle_AsyncIterator = 3915,
  FileSystemDirectoryIterator = 3955,
  FileSystemDirectoryReader = 3983,
  FileSystemEntry = 4009,
  FileSystemFileEntry = 4025,
  FileSystemFileHandle = 4045,
  FileSystemHandle = 4066,
  FileSystemSyncAccessHandle = 4083,
  FileSystemWritableFileStream = 4110,
  Flex = 4139,
  FlexItemValues = 4144,
  FlexLineValues = 4159,
  FluentBundle = 4174,
  FluentBundleAsyncIterator = 4187,
  FluentBundleIterator = 4213,
  FluentPattern = 4234,
  FluentResource = 4248,
  FocusEvent = 4263,
  FontFace = 4274,
  FontFaceSet = 4283,
  FontFaceSetIterator = 4295,
  FontFaceSetLoadEvent = 4315,
  FormData = 4336,
  FormData_Iterator = 4345,
  FormDataEvent = 4363,
  FragmentDirective = 4377,
  FrameCrashedEvent = 4395,
  FrameLoader = 4413,
  GPU = 4425,
  GPUAdapter = 4429,
  GPUAdapterInfo = 4440,
  GPUBindGroup = 4455,
  GPUBindGroupLayout = 4468,
  GPUBuffer = 4487,
  GPUBufferUsage = 4497,
  GPUCanvasContext = 4512,
  GPUColorWrite = 4529,
  GPUCommandBuffer = 4543,
  GPUCommandEncoder = 4560,
  GPUCompilationInfo = 4578,
  GPUCompilationMessage = 4597,
  GPUComputePassEncoder = 4619,
  GPUComputePipeline = 4641,
  GPUDevice = 4660,
  GPUDeviceLostInfo = 4670,
  GPUError = 4688,
  GPUExternalTexture = 4697,
  GPUInternalError = 4716,
  GPUMapMode = 4733,
  GPUOutOfMemoryError = 4744,
  GPUPipelineError = 4764,
  GPUPipelineLayout = 4781,
  GPUQuerySet = 4799,
  GPUQueue = 4811,
  GPURenderBundle = 4820,
  GPURenderBundleEncoder = 4836,
  GPURenderPassEncoder = 4859,
  GPURenderPipeline = 4880,
  GPUSampler = 4898,
  GPUShaderModule = 4909,
  GPUShaderStage = 4925,
  GPUSupportedFeatures = 4940,
  GPUSupportedLimits = 4961,
  GPUTexture = 4980,
  GPUTextureUsage = 4991,
  GPUTextureView = 5007,
  GPUUncapturedErrorEvent = 5022,
  GPUValidationError = 5046,
  GainNode = 5065,
  Gamepad = 5074,
  GamepadAxisMoveEvent = 5082,
  GamepadButton = 5103,
  GamepadButtonEvent = 5117,
  GamepadEvent = 5136,
  GamepadHapticActuator = 5149,
  GamepadLightIndicator = 5171,
  GamepadPose = 5193,
  GamepadServiceTest = 5205,
  GamepadTouch = 5224,
  Geolocation = 5237,
  GeolocationCoordinates = 5249,
  GeolocationPosition = 5272,
  GeolocationPositionError = 5292,
  GetUserMediaRequest = 5317,
  GleanBoolean = 5337,
  GleanCategory = 5350,
  GleanCounter = 5364,
  GleanCustomDistribution = 5377,
  GleanDatetime = 5401,
  GleanDenominator = 5415,
  GleanEvent = 5432,
  GleanImpl = 5443,
  GleanLabeled = 5453,
  GleanMemoryDistribution = 5466,
  GleanMetric = 5490,
  GleanNumerator = 5502,
  GleanObject = 5517,
  GleanPingsImpl = 5529,
  GleanQuantity = 5544,
  GleanRate = 5558,
  GleanString = 5568,
  GleanStringList = 5580,
  GleanText = 5596,
  GleanTimespan = 5606,
  GleanTimingDistribution = 5620,
  GleanUrl = 5644,
  GleanUuid = 5653,
  Grid = 5663,
  GridArea = 5668,
  GridDimension = 5677,
  GridLine = 5691,
  GridLines = 5700,
  GridTrack = 5710,
  GridTracks = 5720,
  HTMLAllCollection = 5731,
  HTMLAnchorElement = 5749,
  HTMLAreaElement = 5767,
  HTMLAudioElement = 5783,
  HTMLBRElement = 5800,
  HTMLBaseElement = 5814,
  HTMLBodyElement = 5830,
  HTMLButtonElement = 5846,
  HTMLCanvasElement = 5864,
  HTMLCollection = 5882,
  HTMLDListElement = 5897,
  HTMLDataElement = 5914,
  HTMLDataListElement = 5930,
  HTMLDetailsElement = 5950,
  HTMLDialogElement = 5969,
  HTMLDirectoryElement = 5987,
  HTMLDivElement = 6008,
  HTMLDocument = 6023,
  HTMLElement = 6036,
  HTMLEmbedElement = 6048,
  HTMLFieldSetElement = 6065,
  HTMLFontElement = 6085,
  HTMLFormControlsCollection = 6101,
  HTMLFormElement = 6128,
  HTMLFrameElement = 6144,
  HTMLFrameSetElement = 6161,
  HTMLHRElement = 6181,
  HTMLHeadElement = 6195,
  HTMLHeadingElement = 6211,
  HTMLHtmlElement = 6230,
  HTMLIFrameElement = 6246,
  HTMLImageElement = 6264,
  HTMLInputElement = 6281,
  HTMLLIElement = 6298,
  HTMLLabelElement = 6312,
  HTMLLegendElement = 6329,
  HTMLLinkElement = 6347,
  HTMLMapElement = 6363,
  HTMLMarqueeElement = 6378,
  HTMLMediaElement = 6397,
  HTMLMenuElement = 6414,
  HTMLMetaElement = 6430,
  HTMLMeterElement = 6446,
  HTMLModElement = 6463,
  HTMLOListElement = 6478,
  HTMLObjectElement = 6495,
  HTMLOptGroupElement = 6513,
  HTMLOptionElement = 6533,
  HTMLOptionsCollection = 6551,
  HTMLOutputElement = 6573,
  HTMLParagraphElement = 6591,
  HTMLParamElement = 6612,
  HTMLPictureElement = 6629,
  HTMLPreElement = 6648,
  HTMLProgressElement = 6663,
  HTMLQuoteElement = 6683,
  HTMLScriptElement = 6700,
  HTMLSelectElement = 6718,
  HTMLSlotElement = 6736,
  HTMLSourceElement = 6752,
  HTMLSpanElement = 6770,
  HTMLStyleElement = 6786,
  HTMLTableCaptionElement = 6803,
  HTMLTableCellElement = 6827,
  HTMLTableColElement = 6848,
  HTMLTableElement = 6868,
  HTMLTableRowElement = 6885,
  HTMLTableSectionElement = 6905,
  HTMLTemplateElement = 6929,
  HTMLTextAreaElement = 6949,
  HTMLTimeElement = 6969,
  HTMLTitleElement = 6985,
  HTMLTrackElement = 7002,
  HTMLUListElement = 7019,
  HTMLUnknownElement = 7036,
  HTMLVideoElement = 7055,
  HashChangeEvent = 7072,
  Headers = 7088,
  Headers_Iterator = 7096,
  HeapSnapshot = 7113,
  Highlight = 7126,
  HighlightRegistry = 7136,
  History = 7154,
  IDBCursor = 7162,
  IDBCursorWithValue = 7172,
  IDBDatabase = 7191,
  IDBFactory = 7203,
  IDBIndex = 7214,
  IDBKeyRange = 7223,
  IDBObjectStore = 7235,
  IDBOpenDBRequest = 7250,
  IDBRequest = 7267,
  IDBTransaction = 7278,
  IDBVersionChangeEvent = 7293,
  IIRFilterNode = 7315,
  IOUtils = 7329,
  IdentityCredential = 7337,
  IdleDeadline = 7356,
  Image = 7369,
  ImageBitmap = 7375,
  ImageBitmapRenderingContext = 7387,
  ImageCapture = 7415,
  ImageCaptureError = 7428,
  ImageCaptureErrorEvent = 7446,
  ImageData = 7469,
  ImageDecoder = 7479,
  ImageDocument = 7492,
  ImageTrack = 7506,
  ImageTrackList = 7517,
  InputEvent = 7532,
  InspectorCSSParser = 7543,
  InspectorFontFace = 7562,
  InspectorUtils = 7580,
  InstallTriggerImpl = 7595,
  IntersectionObserver = 7614,
  IntersectionObserverEntry = 7635,
  IntlUtils = 7661,
  InvokeEvent = 7671,
  JSProcessActorChild = 7683,
  JSProcessActorParent = 7703,
  JSWindowActorChild = 7724,
  JSWindowActorParent = 7743,
  KeyEvent = 7763,
  KeyboardEvent = 7772,
  KeyframeEffect = 7786,
  L10nFileSource = 7801,
  L10nOverlays = 7816,
  L10nRegistry = 7829,
  LargestContentfulPaint = 7842,
  LegacyMozTCPSocket = 7865,
  Localization = 7884,
  Location = 7897,
  Lock = 7906,
  LockManager = 7911,
  MIDIAccess = 7923,
  MIDIConnectionEvent = 7934,
  MIDIInput = 7954,
  MIDIInputMap = 7964,
  MIDIMessageEvent = 7977,
  MIDIOutput = 7994,
  MIDIOutputMap = 8005,
  MIDIPort = 8019,
  MLS = 8028,
  MLSGroupView = 8032,
  MOZ_debug = 8045,
  MatchGlob = 8055,
  MatchPattern = 8065,
  MatchPatternSet = 8078,
  MathMLElement = 8094,
  MediaCapabilities = 8108,
  MediaControlService = 8126,
  MediaController = 8146,
  MediaDeviceInfo = 8162,
  MediaDevices = 8178,
  MediaElementAudioSourceNode = 8191,
  MediaEncryptedEvent = 8219,
  MediaError = 8239,
  MediaKeyError = 8250,
  MediaKeyMessageEvent = 8264,
  MediaKeySession = 8285,
  MediaKeyStatusMap = 8301,
  MediaKeyStatusMap_Iterator = 8319,
  MediaKeySystemAccess = 8346,
  MediaKeys = 8367,
  MediaList = 8377,
  MediaMetadata = 8387,
  MediaQueryList = 8401,
  MediaQueryListEvent = 8416,
  MediaRecorder = 8436,
  MediaRecorderErrorEvent = 8450,
  MediaSession = 8474,
  MediaSource = 8487,
  MediaStream = 8499,
  MediaStreamAudioDestinationNode = 8511,
  MediaStreamAudioSourceNode = 8543,
  MediaStreamError = 8570,
  MediaStreamEvent = 8587,
  MediaStreamTrack = 8604,
  MediaStreamTrackAudioSourceNode = 8621,
  MediaStreamTrackEvent = 8653,
  MerchantValidationEvent = 8675,
  MessageBroadcaster = 8699,
  MessageChannel = 8718,
  MessageEvent = 8733,
  MessageListenerManager = 8746,
  MessagePort = 8769,
  MessageSender = 8781,
  MimeType = 8795,
  MimeTypeArray = 8804,
  MouseEvent = 8818,
  MouseScrollEvent = 8829,
  MozCanvasPrintState = 8846,
  MozDocumentMatcher = 8866,
  MozDocumentObserver = 8885,
  MozQueryInterface = 8905,
  MozSharedMap = 8923,
  MozSharedMap_Iterator = 8936,
  MozSharedMapChangeEvent = 8958,
  MozStorageAsyncStatementParams = 8982,
  MozStorageStatementParams = 9013,
  MozStorageStatementRow = 9039,
  MozWritableSharedMap = 9062,
  MutationEvent = 9083,
  MutationObserver = 9097,
  MutationRecord = 9114,
  NamedNodeMap = 9129,
  NavigateEvent = 9142,
  Navigation = 9156,
  NavigationActivation = 9167,
  NavigationCurrentEntryChangeEvent = 9188,
  NavigationDestination = 9222,
  NavigationHistoryEntry = 9244,
  NavigationPreloadManager = 9267,
  NavigationTransition = 9292,
  Navigator = 9313,
  NavigatorLogin = 9323,
  NetworkInformation = 9338,
  Node = 9357,
  NodeFilter = 9362,
  NodeIterator = 9373,
  NodeList = 9386,
  Notification = 9395,
  NotificationEvent = 9408,
  NotifyPaintEvent = 9426,
  OES_draw_buffers_indexed = 9443,
  OES_element_index_uint = 9468,
  OES_fbo_render_mipmap = 9491,
  OES_standard_derivatives = 9513,
  OES_texture_float = 9538,
  OES_texture_float_linear = 9556,
  OES_texture_half_float = 9581,
  OES_texture_half_float_linear = 9604,
  OES_vertex_array_object = 9634,
  OVR_multiview2 = 9658,
  OfflineAudioCompletionEvent = 9673,
  OfflineAudioContext = 9701,
  OffscreenCanvas = 9721,
  OffscreenCanvasRenderingContext2D = 9737,
  Option = 9771,
  OscillatorNode = 9778,
  PageTransitionEvent = 9793,
  PaintRequest = 9813,
  PaintRequestList = 9826,
  PaintWorkletGlobalScope = 9843,
  PannerNode = 9867,
  ParentProcessMessageManager = 9878,
  Path2D = 9906,
  PathUtils = 9913,
  PaymentAddress = 9923,
  PaymentMethodChangeEvent = 9938,
  PaymentRequest = 9963,
  PaymentRequestUpdateEvent = 9978,
  PaymentResponse = 10004,
  PeerConnectionImpl = 10020,
  PeerConnectionObserver = 10039,
  Performance = 10062,
  PerformanceEntry = 10074,
  PerformanceEntryEvent = 10091,
  PerformanceEventTiming = 10113,
  PerformanceMark = 10136,
  PerformanceMeasure = 10152,
  PerformanceNavigation = 10171,
  PerformanceNavigationTiming = 10193,
  PerformanceObserver = 10221,
  PerformanceObserverEntryList = 10241,
  PerformancePaintTiming = 10270,
  PerformanceResourceTiming = 10293,
  PerformanceServerTiming = 10319,
  PerformanceTiming = 10343,
  PeriodicWave = 10361,
  PermissionStatus = 10374,
  Permissions = 10391,
  PlacesBookmark = 10403,
  PlacesBookmarkAddition = 10418,
  PlacesBookmarkChanged = 10441,
  PlacesBookmarkGuid = 10463,
  PlacesBookmarkKeyword = 10482,
  PlacesBookmarkMoved = 10504,
  PlacesBookmarkRemoved = 10524,
  PlacesBookmarkTags = 10546,
  PlacesBookmarkTime = 10565,
  PlacesBookmarkTitle = 10584,
  PlacesBookmarkUrl = 10604,
  PlacesEvent = 10622,
  PlacesEventCounts = 10634,
  PlacesFavicon = 10652,
  PlacesHistoryCleared = 10666,
  PlacesObservers = 10687,
  PlacesPurgeCaches = 10703,
  PlacesRanking = 10721,
  PlacesVisit = 10735,
  PlacesVisitRemoved = 10747,
  PlacesVisitTitle = 10766,
  PlacesWeakCallbackWrapper = 10783,
  Plugin = 10809,
  PluginArray = 10816,
  PluginCrashedEvent = 10828,
  PointerEvent = 10847,
  PopStateEvent = 10860,
  PopupBlockedEvent = 10874,
  PopupPositionedEvent = 10892,
  PositionStateEvent = 10913,
  PrecompiledScript = 10932,
  PrivateAttribution = 10950,
  ProcessMessageManager = 10969,
  ProcessingInstruction = 10991,
  ProgressEvent = 11013,
  PromiseDebugging = 11027,
  PromiseNativeHandler = 11044,
  PromiseRejectionEvent = 11065,
  PublicKeyCredential = 11087,
  PushEvent = 11107,
  PushManager = 11117,
  PushManagerImpl = 11129,
  PushMessageData = 11145,
  PushSubscription = 11161,
  PushSubscriptionChangeEvent = 11178,
  PushSubscriptionOptions = 11206,
  RTCCertificate = 11230,
  RTCDTMFSender = 11245,
  RTCDTMFToneChangeEvent = 11259,
  RTCDataChannel = 11282,
  RTCDataChannelEvent = 11297,
  RTCDtlsTransport = 11317,
  RTCEncodedAudioFrame = 11334,
  RTCEncodedVideoFrame = 11355,
  RTCIceCandidate = 11376,
  RTCIceTransport = 11392,
  RTCIdentityProviderRegistrar = 11408,
  RTCPeerConnection = 11437,
  RTCPeerConnectionIceEvent = 11455,
  RTCPeerConnectionStatic = 11481,
  RTCRtpReceiver = 11505,
  RTCRtpScriptTransform = 11520,
  RTCRtpScriptTransformer = 11542,
  RTCRtpSender = 11566,
  RTCRtpTransceiver = 11579,
  RTCSctpTransport = 11597,
  RTCSessionDescription = 11614,
  RTCStatsReport = 11636,
  RTCTrackEvent = 11651,
  RTCTransformEvent = 11665,
  RadioNodeList = 11683,
  Range = 11697,
  ReadableByteStreamController = 11703,
  ReadableStream = 11732,
  ReadableStream_AsyncIterator = 11747,
  ReadableStreamBYOBReader = 11776,
  ReadableStreamBYOBRequest = 11801,
  ReadableStreamDefaultController = 11827,
  ReadableStreamDefaultReader = 11859,
  RedirectBlockedEvent = 11887,
  Report = 11908,
  ReportBody = 11915,
  ReportingObserver = 11926,
  Request = 11944,
  ResizeObserver = 11952,
  ResizeObserverEntry = 11967,
  ResizeObserverSize = 11987,
  Response = 12006,
  SVGAElement = 12015,
  SVGAngle = 12027,
  SVGAnimateElement = 12036,
  SVGAnimateMotionElement = 12054,
  SVGAnimateTransformElement = 12078,
  SVGAnimatedAngle = 12105,
  SVGAnimatedBoolean = 12122,
  SVGAnimatedEnumeration = 12141,
  SVGAnimatedInteger = 12164,
  SVGAnimatedLength = 12183,
  SVGAnimatedLengthList = 12201,
  SVGAnimatedNumber = 12223,
  SVGAnimatedNumberList = 12241,
  SVGAnimatedPreserveAspectRatio = 12263,
  SVGAnimatedRect = 12294,
  SVGAnimatedString = 12310,
  SVGAnimatedTransformList = 12328,
  SVGAnimationElement = 12353,
  SVGCircleElement = 12373,
  SVGClipPathElement = 12390,
  SVGComponentTransferFunctionElement = 12409,
  SVGDefsElement = 12445,
  SVGDescElement = 12460,
  SVGElement = 12475,
  SVGEllipseElement = 12486,
  SVGFEBlendElement = 12504,
  SVGFEColorMatrixElement = 12522,
  SVGFEComponentTransferElement = 12546,
  SVGFECompositeElement = 12576,
  SVGFEConvolveMatrixElement = 12598,
  SVGFEDiffuseLightingElement = 12625,
  SVGFEDisplacementMapElement = 12653,
  SVGFEDistantLightElement = 12681,
  SVGFEDropShadowElement = 12706,
  SVGFEFloodElement = 12729,
  SVGFEFuncAElement = 12747,
  SVGFEFuncBElement = 12765,
  SVGFEFuncGElement = 12783,
  SVGFEFuncRElement = 12801,
  SVGFEGaussianBlurElement = 12819,
  SVGFEImageElement = 12844,
  SVGFEMergeElement = 12862,
  SVGFEMergeNodeElement = 12880,
  SVGFEMorphologyElement = 12902,
  SVGFEOffsetElement = 12925,
  SVGFEPointLightElement = 12944,
  SVGFESpecularLightingElement = 12967,
  SVGFESpotLightElement = 12996,
  SVGFETileElement = 13018,
  SVGFETurbulenceElement = 13035,
  SVGFilterElement = 13058,
  SVGForeignObjectElement = 13075,
  SVGGElement = 13099,
  SVGGeometryElement = 13111,
  SVGGradientElement = 13130,
  SVGGraphicsElement = 13149,
  SVGImageElement = 13168,
  SVGLength = 13184,
  SVGLengthList = 13194,
  SVGLineElement = 13208,
  SVGLinearGradientElement = 13223,
  SVGMPathElement = 13248,
  SVGMarkerElement = 13264,
  SVGMaskElement = 13281,
  SVGMatrix = 13296,
  SVGMetadataElement = 13306,
  SVGNumber = 13325,
  SVGNumberList = 13335,
  SVGPathElement = 13349,
  SVGPathSegment = 13364,
  SVGPatternElement = 13379,
  SVGPoint = 13397,
  SVGPointList = 13406,
  SVGPolygonElement = 13419,
  SVGPolylineElement = 13437,
  SVGPreserveAspectRatio = 13456,
  SVGRadialGradientElement = 13479,
  SVGRect = 13504,
  SVGRectElement = 13512,
  SVGSVGElement = 13527,
  SVGScriptElement = 13541,
  SVGSetElement = 13558,
  SVGStopElement = 13572,
  SVGStringList = 13587,
  SVGStyleElement = 13601,
  SVGSwitchElement = 13617,
  SVGSymbolElement = 13634,
  SVGTSpanElement = 13651,
  SVGTextContentElement = 13667,
  SVGTextElement = 13689,
  SVGTextPathElement = 13704,
  SVGTextPositioningElement = 13723,
  SVGTitleElement = 13749,
  SVGTransform = 13765,
  SVGTransformList = 13778,
  SVGUnitTypes = 13795,
  SVGUseElement = 13808,
  SVGViewElement = 13822,
  Sanitizer = 13837,
  Scheduler = 13847,
  Screen = 13857,
  ScreenLuminance = 13864,
  ScreenOrientation = 13880,
  ScriptProcessorNode = 13898,
  ScrollAreaEvent = 13918,
  SecurityPolicyViolationEvent = 13934,
  Selection = 13963,
  ServiceWorker = 13973,
  ServiceWorkerContainer = 13987,
  ServiceWorkerGlobalScope = 14010,
  ServiceWorkerRegistration = 14035,
  SessionStoreFormData = 14061,
  SessionStoreScrollData = 14082,
  SessionStoreUtils = 14105,
  ShadowRealmGlobalScope = 14123,
  ShadowRoot = 14146,
  SharedWorker = 14157,
  SharedWorkerGlobalScope = 14170,
  SimpleGestureEvent = 14194,
  SourceBuffer = 14213,
  SourceBufferList = 14226,
  SpeechGrammar = 14243,
  SpeechGrammarList = 14257,
  SpeechRecognition = 14275,
  SpeechRecognitionAlternative = 14293,
  SpeechRecognitionError = 14322,
  SpeechRecognitionEvent = 14345,
  SpeechRecognitionResult = 14368,
  SpeechRecognitionResultList = 14392,
  SpeechSynthesis = 14420,
  SpeechSynthesisErrorEvent = 14436,
  SpeechSynthesisEvent = 14462,
  SpeechSynthesisUtterance = 14483,
  SpeechSynthesisVoice = 14508,
  StaticRange = 14529,
  StereoPannerNode = 14541,
  Storage = 14558,
  StorageEvent = 14566,
  StorageManager = 14579,
  StreamFilter = 14594,
  StreamFilterDataEvent = 14607,
  StructuredCloneHolder = 14629,
  StructuredCloneTester = 14651,
  StyleSheet = 14673,
  StyleSheetApplicableStateChangeEvent = 14684,
  StyleSheetList = 14721,
  StyleSheetRemovedEvent = 14736,
  SubmitEvent = 14759,
  SubtleCrypto = 14771,
  SyncMessageSender = 14784,
  SyncReadFile = 14802,
  TCPServerSocket = 14815,
  TCPServerSocketEvent = 14831,
  TCPSocket = 14852,
  TCPSocketErrorEvent = 14862,
  TCPSocketEvent = 14882,
  TaskController = 14897,
  TaskPriorityChangeEvent = 14912,
  TaskSignal = 14936,
  TestUtils = 14947,
  TestingDeprecatedInterface = 14957,
  Text = 14984,
  TextClause = 14989,
  TextDecoder = 15000,
  TextDecoderStream = 15012,
  TextEncoder = 15030,
  TextEncoderStream = 15042,
  TextEvent = 15060,
  TextMetrics = 15070,
  TextTrack = 15082,
  TextTrackCue = 15092,
  TextTrackCueList = 15105,
  TextTrackList = 15122,
  TimeEvent = 15136,
  TimeRanges = 15146,
  ToggleEvent = 15157,
  Touch = 15169,
  TouchEvent = 15175,
  TouchList = 15186,
  TrackEvent = 15196,
  TransformStream = 15207,
  TransformStreamDefaultController = 15223,
  TransitionEvent = 15256,
  TreeColumn = 15272,
  TreeColumns = 15283,
  TreeContentView = 15295,
  TreeWalker = 15311,
  TrustedHTML = 15322,
  TrustedScript = 15334,
  TrustedScriptURL = 15348,
  TrustedTypePolicy = 15365,
  TrustedTypePolicyFactory = 15383,
  UDPMessageEvent = 15408,
  UDPSocket = 15424,
  UIEvent = 15434,
  URL = 15442,
  URLSearchParams = 15446,
  URLSearchParams_Iterator = 15462,
  UniFFIPointer = 15487,
  UniFFIScaffolding = 15501,
  UserActivation = 15519,
  UserInteraction = 15534,
  UserProximityEvent = 15550,
  VRDisplay = 15569,
  VRDisplayCapabilities = 15579,
  VRDisplayEvent = 15601,
  VREyeParameters = 15616,
  VRFieldOfView = 15632,
  VRFrameData = 15646,
  VRMockController = 15658,
  VRMockDisplay = 15675,
  VRPose = 15689,
  VRServiceTest = 15696,
  VRStageParameters = 15710,
  VTTCue = 15728,
  VTTRegion = 15735,
  ValidityState = 15745,
  VideoColorSpace = 15759,
  VideoDecoder = 15775,
  VideoEncoder = 15788,
  VideoFrame = 15801,
  VideoPlaybackQuality = 15812,
  VideoTrack = 15833,
  VideoTrackList = 15844,
  ViewTransition = 15859,
  VisualViewport = 15874,
  WEBGL_color_buffer_float = 15889,
  WEBGL_compressed_texture_astc = 15914,
  WEBGL_compressed_texture_etc = 15944,
  WEBGL_compressed_texture_etc1 = 15973,
  WEBGL_compressed_texture_pvrtc = 16003,
  WEBGL_compressed_texture_s3tc = 16034,
  WEBGL_compressed_texture_s3tc_srgb = 16064,
  WEBGL_debug_renderer_info = 16099,
  WEBGL_debug_shaders = 16125,
  WEBGL_depth_texture = 16145,
  WEBGL_draw_buffers = 16165,
  WEBGL_explicit_present = 16184,
  WEBGL_lose_context = 16207,
  WEBGL_provoking_vertex = 16226,
  WGSLLanguageFeatures = 16249,
  WakeLock = 16270,
  WakeLockSentinel = 16279,
  WaveShaperNode = 16296,
  WebExtensionContentScript = 16311,
  WebExtensionPolicy = 16337,
  WebGL2RenderingContext = 16356,
  WebGLActiveInfo = 16379,
  WebGLBuffer = 16395,
  WebGLContextEvent = 16407,
  WebGLFramebuffer = 16425,
  WebGLProgram = 16442,
  WebGLQuery = 16455,
  WebGLRenderbuffer = 16466,
  WebGLRenderingContext = 16484,
  WebGLSampler = 16506,
  WebGLShader = 16519,
  WebGLShaderPrecisionFormat = 16531,
  WebGLSync = 16558,
  WebGLTexture = 16568,
  WebGLTransformFeedback = 16581,
  WebGLUniformLocation = 16604,
  WebGLVertexArrayObject = 16625,
  WebKitCSSMatrix = 16648,
  WebSocket = 16664,
  WebTransport = 16674,
  WebTransportBidirectionalStream = 16687,
  WebTransportDatagramDuplexStream = 16719,
  WebTransportError = 16752,
  WebTransportReceiveStream = 16770,
  WebTransportSendStream = 16796,
  WebrtcGlobalInformation = 16819,
  WheelEvent = 16843,
  Window = 16854,
  WindowClient = 16861,
  WindowContext = 16874,
  WindowGlobalChild = 16888,
  WindowGlobalParent = 16906,
  WindowRoot = 16925,
  Worker = 16936,
  WorkerDebuggerGlobalScope = 16943,
  WorkerGlobalScope = 16969,
  WorkerLocation = 16987,
  WorkerNavigator = 17002,
  WorkerTestUtils = 17018,
  Worklet = 17034,
  WorkletGlobalScope = 17042,
  WritableStream = 17061,
  WritableStreamDefaultController = 17076,
  WritableStreamDefaultWriter = 17108,
  XMLDocument = 17136,
  XMLHttpRequest = 17148,
  XMLHttpRequestEventTarget = 17163,
  XMLHttpRequestUpload = 17189,
  XMLSerializer = 17210,
  XPathEvaluator = 17224,
  XPathExpression = 17239,
  XPathResult = 17255,
  XRBoundedReferenceSpace = 17267,
  XRFrame = 17291,
  XRInputSource = 17299,
  XRInputSourceArray = 17313,
  XRInputSourceEvent = 17332,
  XRInputSourcesChangeEvent = 17351,
  XRPose = 17377,
  XRReferenceSpace = 17384,
  XRReferenceSpaceEvent = 17401,
  XRRenderState = 17423,
  XRRigidTransform = 17437,
  XRSession = 17454,
  XRSessionEvent = 17464,
  XRSpace = 17479,
  XRSystem = 17487,
  XRView = 17496,
  XRViewerPose = 17503,
  XRViewport = 17516,
  XRWebGLLayer = 17527,
  XSLTProcessor = 17540,
  XULCommandEvent = 17554,
  XULElement = 17570,
  XULFrameElement = 17581,
  XULMenuElement = 17597,
  XULPopupElement = 17612,
  XULResizerElement = 17628,
  XULTextElement = 17646,
  XULTreeElement = 17661,
  console = 17676,
  webkitSpeechGrammar = 17684,
  webkitSpeechGrammarList = 17704,
  webkitSpeechRecognition = 17728,
  webkitURL = 17752,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // DOM_BINDINGNAMES_H_
