/* THIS FILE IS AUTOGENERATED FROM Transformer.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_TRANSFORMERBINDING_H_
#define DOM_TRANSFORMERBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/ToJSValue.h"

namespace mozilla {
namespace dom {

struct NativePropertyHooks;
class Promise;
class ProtoAndIfaceCache;
class TransformStreamDefaultController;
struct TransformerAtoms;
class TransformerFlushCallback;
class TransformerStartCallback;
class TransformerTransformCallback;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

struct Transformer : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<TransformerFlushCallback>> mFlush;
  MOZ_INIT_OUTSIDE_CTOR JS::Value mReadableType;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<TransformerStartCallback>> mStart;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<TransformerTransformCallback>> mTransform;
  MOZ_INIT_OUTSIDE_CTOR JS::Value mWritableType;

  Transformer();

  explicit inline Transformer(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  Transformer(Transformer&& aOther) = default;

private:
  Transformer(const Transformer&) = delete;
  Transformer& operator=(const Transformer&) = delete;

  static bool
  InitIds(JSContext* cx, TransformerAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mFlush, "mFlush", aFlags);
    ImplCycleCollectionTraverse(aCallback, mStart, "mStart", aFlags);
    ImplCycleCollectionTraverse(aCallback, mTransform, "mTransform", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mFlush);
    ImplCycleCollectionUnlink(mStart);
    ImplCycleCollectionUnlink(mTransform);
  }
};

namespace binding_detail {
struct FastTransformer : public Transformer
{
  inline FastTransformer()
    : Transformer(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class TransformerFlushCallback : public CallbackFunction
{
public:
  explicit inline TransformerFlushCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline TransformerFlushCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline TransformerFlushCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline TransformerFlushCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline already_AddRefed<Promise>
  Call(const T& thisVal, TransformStreamDefaultController& controller, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "TransformerFlushCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return nullptr;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return nullptr;
    }
    return Call(s.GetCallContext(), thisValJS, controller, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline already_AddRefed<Promise>
  Call(TransformStreamDefaultController& controller, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "TransformerFlushCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return nullptr;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, controller, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline already_AddRefed<Promise>
  Call(const T& thisVal, TransformStreamDefaultController& controller, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, controller, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline already_AddRefed<Promise>
  Call(TransformStreamDefaultController& controller, const char* aExecutionReason = nullptr)
  {
    return Call(controller, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const TransformerFlushCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT already_AddRefed<Promise> Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, TransformStreamDefaultController& controller, ErrorResult& aRv);
};


namespace binding_detail {
class FastTransformerFlushCallback : public TransformerFlushCallback
{
public:
  explicit inline FastTransformerFlushCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : TransformerFlushCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    TransformerFlushCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    TransformerFlushCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


class TransformerStartCallback : public CallbackFunction
{
public:
  explicit inline TransformerStartCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline TransformerStartCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline TransformerStartCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline TransformerStartCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, TransformStreamDefaultController& controller, JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "TransformerStartCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, controller, aRetVal, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(TransformStreamDefaultController& controller, JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "TransformerStartCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, controller, aRetVal, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, TransformStreamDefaultController& controller, JS::MutableHandle<JS::Value> aRetVal, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, controller, aRetVal, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(TransformStreamDefaultController& controller, JS::MutableHandle<JS::Value> aRetVal, const char* aExecutionReason = nullptr)
  {
    return Call(controller, aRetVal, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const TransformerStartCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, TransformStreamDefaultController& controller, JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv);
};


namespace binding_detail {
class FastTransformerStartCallback : public TransformerStartCallback
{
public:
  explicit inline FastTransformerStartCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : TransformerStartCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    TransformerStartCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    TransformerStartCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


class TransformerTransformCallback : public CallbackFunction
{
public:
  explicit inline TransformerTransformCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline TransformerTransformCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline TransformerTransformCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline TransformerTransformCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline already_AddRefed<Promise>
  Call(const T& thisVal, JS::Handle<JS::Value> chunk, TransformStreamDefaultController& controller, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "TransformerTransformCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return nullptr;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return nullptr;
    }
    return Call(s.GetCallContext(), thisValJS, chunk, controller, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline already_AddRefed<Promise>
  Call(JS::Handle<JS::Value> chunk, TransformStreamDefaultController& controller, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "TransformerTransformCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return nullptr;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, chunk, controller, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline already_AddRefed<Promise>
  Call(const T& thisVal, JS::Handle<JS::Value> chunk, TransformStreamDefaultController& controller, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, chunk, controller, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline already_AddRefed<Promise>
  Call(JS::Handle<JS::Value> chunk, TransformStreamDefaultController& controller, const char* aExecutionReason = nullptr)
  {
    return Call(chunk, controller, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const TransformerTransformCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT already_AddRefed<Promise> Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, JS::Handle<JS::Value> chunk, TransformStreamDefaultController& controller, ErrorResult& aRv);
};


namespace binding_detail {
class FastTransformerTransformCallback : public TransformerTransformCallback
{
public:
  explicit inline FastTransformerTransformCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : TransformerTransformCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    TransformerTransformCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    TransformerTransformCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


} // namespace mozilla::dom

#endif // DOM_TRANSFORMERBINDING_H_
